/*
This file is part of mfaktc.
Copyright (C) 2009, 2010, 2011, 2012  Oliver Weihe (o.weihe@t-online.de)
                                      Bertram Franz (bertramf@gmx.net)

mfaktc is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mfaktc is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                
You should have received a copy of the GNU General Public License
along with mfaktc.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <string.h>
#include <cuda_runtime.h>

#include "params.h"
#include "my_types.h"

int my_read_int(char *inifile, char *name, int *value)
{
  FILE *in;
  char buf[100];
  int found=0;

  in=fopen(inifile,"r");
  if(!in)return 1;
  while(fgets(buf,100,in) && !found)
  {
    if(!strncmp(buf,name,strlen(name)) && buf[strlen(name)]=='=')
    {
      if(sscanf(&(buf[strlen(name)+1]),"%d",value)==1)found=1;
    }
  }
  fclose(in);
  if(found)return 0;
  return 1;
}


int my_read_string(char *inifile, char *name, char *string, unsigned int len)
{
  FILE *in;
  char buf[256];
  unsigned int found = 0;
  unsigned int idx = strlen(name);

  if(len > 250) len = 250;
  
  in = fopen(inifile, "r");
  if(!in)return 1;
  while(fgets(buf, 250, in) && !found)
  {
    if(!strncmp(buf, name, idx) && buf[idx] == '=')
    {
      found = strlen(buf + idx + 1);
      found = (len > found ? found : len) - 1;
      if (found)
        strncpy(string, buf + idx + 1, found);
      string[found] = '\0';
    }
  }  
  fclose(in);
  if(found >= 1)return 0;
  return 1;
}


int read_config(mystuff_t *mystuff)
{
  int i;
  if(mystuff->verbosity >= 1)printf("\nRuntime options\n");

//  if(my_read_int("mmff.ini", "SievePrimes", &i))
//  {
//    printf("WARNING: Cannot read SievePrimes from mmff.ini, using default value (%d)\n",SIEVE_PRIMES_DEFAULT);
//    i = SIEVE_PRIMES_DEFAULT;
//  }
//  else
//  {
//    if(i > SIEVE_PRIMES_MAX)
//    {
//      printf("WARNING: Read SievePrimes=%d from mmff.ini, using max value (%d)\n",i,SIEVE_PRIMES_MAX);
//      i = SIEVE_PRIMES_MAX;
//    }
//    else if(i < SIEVE_PRIMES_MIN)
//    {
//      printf("WARNING: Read SievePrimes=%d from mmff.ini, using min value (%d)\n",i,SIEVE_PRIMES_MIN);
//      i = SIEVE_PRIMES_MIN;
//    }
//  }
//  if(mystuff->verbosity >= 1)printf("  SievePrimes               %d\n",i);
//  mystuff->sieve_primes = i;

/*****************************************************************************/  

//  if(my_read_int("mmff.ini", "SievePrimesAdjust", &i))
//  {
//    printf("WARNING: Cannot read SievePrimesAdjust from mmff.ini, using default value (1)\n");
//    i = 1;
//  }
//  else if(i != 0 && i != 1)
//  {
//    printf("WARNING: SievePrimesAdjust must be 0 or 1, using default value (1)\n");
//    i = 1;
//  }
//  if(mystuff->verbosity >= 1)printf("  SievePrimesAdjust         %d\n",i);
//  mystuff->sieve_primes_adjust = i;

/*****************************************************************************/

//  if(my_read_int("mmff.ini", "SievePrimesMin", &i))
//  {
//    printf("WARNING: Cannot read SievePrimesMin from mmff.ini, using min value (%d)\n",SIEVE_PRIMES_MIN);
//    i = SIEVE_PRIMES_MIN;
//  }
//  else
//  {
//    if(i < SIEVE_PRIMES_MIN || i >= SIEVE_PRIMES_MAX || i > mystuff->sieve_primes)
//    {
//      printf("WARNING: Read SievePrimesMin=%d from mmff.ini, using min value (%d)\n",i,SIEVE_PRIMES_MIN);
//      i = SIEVE_PRIMES_MIN;
//    }
//  }
//  if(mystuff->verbosity >= 1)printf("  SievePrimesMin            %d\n",i);
//  mystuff->sieve_primes_min = i;

/*****************************************************************************/

//  if(my_read_int("mmff.ini", "SievePrimesMax", &i))
//  {
//    printf("WARNING: Cannot read SievePrimesMax from mmff.ini, using max value (%d)\n",SIEVE_PRIMES_MAX);
//    i = SIEVE_PRIMES_MAX;
//  }
//  else
//  {
//    if(i <= SIEVE_PRIMES_MIN || i > SIEVE_PRIMES_MAX || i < mystuff->sieve_primes)
//    {
//      printf("WARNING: Read SievePrimesMax=%d from mmff.ini, using max value (%d)\n",i,SIEVE_PRIMES_MAX);
//      i = SIEVE_PRIMES_MAX;
//    }
//  }
//  if(mystuff->verbosity >= 1)printf("  SievePrimesMax            %d\n",i);
//  mystuff->sieve_primes_max = i;

/*****************************************************************************/  

//  if(my_read_int("mmff.ini", "NumStreams", &i))
//  {
//    printf("WARNING: Cannot read NumStreams from mmff.ini, using default value (%d)\n",NUM_STREAMS_DEFAULT);
//    i = NUM_STREAMS_DEFAULT;
//  }
//  else
//  {
//    if(i > NUM_STREAMS_MAX)
//    {
//      printf("WARNING: Read NumStreams=%d from mmff.ini, using max value (%d)\n",i,NUM_STREAMS_MAX);
//      i = NUM_STREAMS_MAX;
//    }
//    else if(i < NUM_STREAMS_MIN)
//    {
//      printf("WARNING: Read NumStreams=%d from mmff.ini, using min value (%d)\n",i,NUM_STREAMS_MIN);
//      i = NUM_STREAMS_MIN;
//    }
//  }
//  if(mystuff->verbosity >= 1)printf("  NumStreams                %d\n",i);
//  mystuff->num_streams = i;

/*****************************************************************************/

//  if(my_read_int("mmff.ini", "CPUStreams", &i))
//  {
//    printf("WARNING: Cannot read CPUStreams from mmff.ini, using default value (%d)\n",CPU_STREAMS_DEFAULT);
//    i = CPU_STREAMS_DEFAULT;
//  }
//  else
//  {
//    if(i > CPU_STREAMS_MAX)
//    {
//      printf("WARNING: Read CPUStreams=%d from mmff.ini, using max value (%d)\n",i,CPU_STREAMS_MAX);
//      i = CPU_STREAMS_MAX;
//    }
//    else if(i < CPU_STREAMS_MIN)
//    {
//      printf("WARNING: Read CPUStreams=%d from mmff.ini, using min value (%d)\n",i,CPU_STREAMS_MIN);
//      i = CPU_STREAMS_MIN;
//    }
//  }
//  if(mystuff->verbosity >= 1)printf("  CPUStreams                %d\n",i);
//  mystuff->cpu_streams = i;

/*****************************************************************************/

//  if(my_read_int("mmff.ini", "GridSize", &i))
//  {
//    printf("WARNING: Cannot read GridSize from mmff.ini, using default value (3)\n");
//    i = 3;
//  }
//  else
//  {
//    if(i > 3)
//    {
//      printf("WARNING: Read GridSize=%d from mmff.ini, using max value (3)\n", i);
//      i = 3;
//    }
//    else if(i < 0)
//    {
//      printf("WARNING: Read GridSize=%d from mmff.ini, using min value (0)\n", i);
//      i = 0;
//    }
//  }
//  if(mystuff->verbosity >= 1)printf("  GridSize                  %d\n",i);
//       if(i == 0)  mystuff->threads_per_grid_max =  131072;
//  else if(i == 1)  mystuff->threads_per_grid_max =  262144;
//  else if(i == 2)  mystuff->threads_per_grid_max =  524288;
//  else             mystuff->threads_per_grid_max = 1048576;

/*****************************************************************************/

  if(mystuff->gpu_sieving) {

    if(mystuff->verbosity >= 1)printf("  GPU Sieving               enabled\n");

/*****************************************************************************/

    if(my_read_int("mmff.ini", "GPUSievePrimes", &i))
    {
      printf("WARNING: Cannot read GPUSievePrimes from mmff.ini, using default value (%d)\n",GPU_SIEVE_PRIMES_DEFAULT);
      i = GPU_SIEVE_PRIMES_DEFAULT;
      mystuff->gpu_sieve_primes_auto = 1;
    }
    else
    {
      if(i > GPU_SIEVE_PRIMES_MAX)
      {
        printf("WARNING: Read GPUSievePrimes=%d from mmff.ini, using max value (%d)\n",i,GPU_SIEVE_PRIMES_MAX);
	i = GPU_SIEVE_PRIMES_MAX;
      }
      else if(i < GPU_SIEVE_PRIMES_MIN)
      {
        printf("WARNING: Read GPUSievePrimes=%d from mmff.ini, using min value (%d)\n",i,GPU_SIEVE_PRIMES_MIN);
	i = GPU_SIEVE_PRIMES_MIN;
      }
      mystuff->gpu_sieve_primes_auto = 0;
    }
    if(mystuff->verbosity >= 1)
    {
      if (mystuff->gpu_sieve_primes_auto) printf("  GPUSievePrimes            depends on worktodo entry\n");
      else printf("  GPUSievePrimes            %d\n",i);
    }
    mystuff->gpu_sieve_primes = i;

/*****************************************************************************/

    if(my_read_int("mmff.ini", "GPUSieveSize", &i))
    {
      printf("WARNING: Cannot read GPUSieveSize from mmff.ini, using default value (%d)\n",GPU_SIEVE_SIZE_DEFAULT);
      i = GPU_SIEVE_SIZE_DEFAULT;
    }
    else
    {
      if(i > GPU_SIEVE_SIZE_MAX)
      {
        printf("WARNING: Read GPUSieveSize=%d from mmff.ini, using max value (%d)\n",i,GPU_SIEVE_SIZE_MAX);
	i = GPU_SIEVE_SIZE_MAX;
      }
      else if(i < GPU_SIEVE_SIZE_MIN)
      {
        printf("WARNING: Read GPUSieveSize=%d from mmff.ini, using min value (%d)\n",i,GPU_SIEVE_SIZE_MIN);
	i = GPU_SIEVE_SIZE_MIN;
      }
    }
    if(mystuff->verbosity >= 1)printf("  GPUSieveSize              %dM bits\n",i);
    mystuff->gpu_sieve_size = i * 1024 * 1024;

/*****************************************************************************/

    if(my_read_int("mmff.ini", "GPUSieveProcessSize", &i))
    {
      printf("WARNING: Cannot read GPUSieveProcessSize from mmff.ini, using default value (%d)\n",GPU_SIEVE_PROCESS_SIZE_DEFAULT);
      i = GPU_SIEVE_PROCESS_SIZE_DEFAULT;
    }
    else
    {
      if(i > GPU_SIEVE_PROCESS_SIZE_MAX)
      {
        printf("WARNING: Read GPUSieveProcessSize=%d from mmff.ini, using max value (%d)\n",i,GPU_SIEVE_PROCESS_SIZE_MAX);
	i = GPU_SIEVE_PROCESS_SIZE_MAX;
      }
      else if(i < GPU_SIEVE_PROCESS_SIZE_MIN)
      {
        printf("WARNING: Read GPUSieveProcessSize=%d from mmff.ini, using min value (%d)\n",i,GPU_SIEVE_PROCESS_SIZE_MIN);
	i = GPU_SIEVE_PROCESS_SIZE_MIN;
      }
      else if(i % 8)
      {
        printf("WARNING: Read GPUSieveProcessSize=%d from mmff.ini.  It must be a multiple of 8, using %d instead\n", i, i & 0xFFFFFFF8);
	i = i & 0xFFFFFFF8;
      }
      if(mystuff->gpu_sieve_size % i)
      {
        printf("WARNING: GPUSieveProcessSize (%d) must evenly divide GPUSieveSize.  Using %d instead\n", i, GPU_SIEVE_PROCESS_SIZE_MIN);
	i = GPU_SIEVE_PROCESS_SIZE_MIN;
      }
    }
    if(mystuff->verbosity >= 1)printf("  GPUSieveProcessSize       %dK bits\n",i);
    mystuff->gpu_sieve_processing_size = i * 1024;
  }

/*****************************************************************************/  
  if(my_read_string("mmff.ini", "WorkFile", mystuff->workfile, 50))
  {
    sprintf(mystuff->workfile, "worktodo.txt");
    printf("WARNING: can't read WorkFile from mmff.ini, using default (%s)\n", mystuff->workfile);
  }
  if(mystuff->verbosity >= 1)printf("  WorkFile                  %s\n", mystuff->workfile);

/*****************************************************************************/

  if(my_read_int("mmff.ini", "Checkpoints", &i))
  {
    printf("WARNING: Cannot read Checkpoints from mmff.ini, enabled by default\n");
    i = 1;
  }
  else if(i != 0 && i != 1)
  {
    printf("WARNING: Checkpoints must be 0 or 1, enabled by default\n");
    i = 1;
  }
  if(mystuff->verbosity >= 1)
  {
    if(i == 0)printf("  Checkpoints               disabled\n");
    else      printf("  Checkpoints               enabled\n");
  }
  mystuff->checkpoints = i;

/*****************************************************************************/

  if(my_read_int("mmff.ini", "CheckpointDelay", &i))
  {
    printf("WARNING: Cannot read CheckpointDelay from mmff.ini, set to 30s by default\n");
    i = 30;
  }
  if(i > 900)
  {
    printf("WARNING: Maximum value for CheckpointDelay is 900s\n");
    i = 900;
  }
  if(i < 0)
  {
    printf("WARNING: Minimum value for CheckpointDelay is 0s\n");
    i = 0;
  }
  if(mystuff->verbosity >= 1)printf("  CheckpointDelay           %ds\n", i);
  mystuff->checkpointdelay = i;

/*****************************************************************************/

//  if(my_read_int("mmff.ini", "Stages", &i))
//  {
//    printf("WARNING: Cannot read Stages from mmff.ini, enabled by default\n");
//    i = 1;
//  }
//  else if(i != 0 && i != 1)
//  {
//    printf("WARNING: Stages must be 0 or 1, enabled by default\n");
//    i = 1;
//  }
//  if(mystuff->verbosity >= 1)
//  {
//    if(i == 0)printf("  Stages                    disabled\n");
//    else      printf("  Stages                    enabled\n");
//  }
//  mystuff->stages = i;
  mystuff->stages = 1;

/*****************************************************************************/

  if(my_read_int("mmff.ini", "StopAfterFactor", &i))
  {
    printf("WARNING: Cannot read StopAfterFactor from mmff.ini, set to 1 by default\n");
    i = 1;
  }
  else if( (i < 0) || (i > 2) )
  {
    printf("WARNING: StopAfterFactor must be 0, 1 or 2, set to 1 by default\n");
    i = 1;
  }
  if(mystuff->verbosity >= 1)
  {
         if(i == 0)printf("  StopAfterFactor           disabled\n");
    else if(i == 1)printf("  StopAfterFactor           bitlevel\n");
    else if(i == 2)printf("  StopAfterFactor           class\n");
  }
  mystuff->stopafterfactor = i;

/*****************************************************************************/

  if(my_read_int("mmff.ini", "PrintMode", &i))
  {
    printf("WARNING: Cannot read PrintMode from mmff.ini, set to 0 by default\n");
    i = 0;
  }
  else if(i != 0 && i != 1)
  {
    printf("WARNING: PrintMode must be 0 or 1, set to 0 by default\n");
    i = 0;
  }
  if(mystuff->verbosity >= 1)
  {
    if(i == 0)printf("  PrintMode                 full\n");
    else      printf("  PrintMode                 compact\n");
  }
  mystuff->printmode = i;

/*****************************************************************************/

  if (my_read_string("mmff.ini", "V5UserID", mystuff->V5UserID, 50))
  {
    /* no problem, don't use any */
    if(mystuff->verbosity >= 1)printf("  V5UserID                  (none)\n");
    mystuff->V5UserID[0]='\0';
  }
  else
  {
    if(mystuff->verbosity >= 1)printf("  V5UserID                  %s\n", mystuff->V5UserID);
  }

/*****************************************************************************/

  if(my_read_string("mmff.ini", "ComputerID", mystuff->ComputerID, 50))
  {
    /* no problem, don't use any */
    if(mystuff->verbosity >= 1)printf("  ComputerID                (none)\n");
    mystuff->ComputerID[0]='\0';
  }
  else
  {   
    if(mystuff->verbosity >= 1)printf("  ComputerID                %s\n", mystuff->ComputerID);
  }

/*****************************************************************************/

  for(i = 0; i < 256; i++)mystuff->stats.gpuprogressheader[i] = 0;
  if(mystuff->gpu_sieving) {
    if(my_read_string("mmff.ini", "GPUProgressHeader", mystuff->stats.gpuprogressheader, 250))
    {
      sprintf(mystuff->stats.gpuprogressheader, "    class |  raw cand. |    time |    ETA |  raw rate | SievePrimes");
      printf("WARNING, no GPUProgressHeader specified in mmff.ini, using default\n");
    }
    if(mystuff->verbosity >= 2)printf("  GPUProgressHeader         \"%s\"\n", mystuff->stats.gpuprogressheader);
  }

/*****************************************************************************/

  for(i = 0; i < 256; i++)mystuff->stats.progressformat[i] = 0;
  if(my_read_string("mmff.ini", "ProgressFormat", mystuff->stats.progressformat, 250))
  {
    sprintf(mystuff->stats.progressformat, "%%C/%4d |    %%n | %%ts | %%e | %%rM/s |     %%s", NUM_CLASSES);
    printf("WARNING, no ProgressFormat specified in mmff.ini, using default\n");
  }
  if(mystuff->verbosity >= 2)printf("  ProgressFormat            \"%s\"\n", mystuff->stats.progressformat);

/*****************************************************************************/

  if(my_read_int("mmff.ini", "TimeStampInResults", &i))
  {
    printf("WARNING: Cannot read TimeStampInResults from mmff.ini, set to 0 by default\n");
    i = 0;
  }
  else if(i < 0 || i > 1)
  {
    printf("WARNING: TimeStampInResults must be 0 or 1, set to 0 by default\n");
    i=0;
  }
  if(mystuff->verbosity >= 1)
  {
    if(i == 0)printf("  TimeStampInResults        no\n");
    else      printf("  TimeStampInResults        yes\n");
  }
  mystuff->print_timestamp = i;

  return 0;
}
